'Login Ver 1.bas

Option EXPLICIT
Option DEFAULT NONE
Option autorun on
option escape
option base 1

'---- general constants ----
const True = 1
const False = 0
const WatchDogOn = True
const UserList = "users.txt"
const Prefix = "aZ3f7"

dim integer i, j, k
dim integer TimeOutVal = 20
dim integer Users = 0, curUser = 0, UserAccess = 0
dim string UserName = "", UserPwd = ""
dim integer UserNameOK = 0, UserPwdOK = 0
dim string pwd = "", LoginMsg = "", PassKey = ""
dim integer StartPos, EndPos

if WatchDogOn then watchdog 60000
do while mm.info(ip address) = "0.0.0.0"
  if timer > 5000 then print "WiFi Timeout, rebooting.": pause 500: cpu restart
  if timer < 1000 then print "Waiting for WiFi."
  pause 1000
loop
print "Connected to WiFi. Local IP Address is " + mm.info$(ip address)

GetUsers

settick 1000, TimeOutInt, 4
WEB TCP INTERRUPT WebInterrupt

do
  if WatchDogOn then watchdog 20000
loop

sub TimeOutInt
  local integer i
  for i = 1 to Users
    if (epoch(now) > UserTimeOutArr(i)) and (UserTimeOutArr(i) <> 0) then
      ? "Timeout on User " + str$(i)
      UserTimeOutArr(i) = 0
      PassKeyArr(i) = ""
    endif
  next i
end sub

sub WebInterrupt
  local Integer ConnNum 
  local integer ConnData(512)
  for ConnNum = 1 to mm.info(Max Connections)
    longstring clear ConnData()
    web tcp read ConnNum, ConnData()
    if llen(ConnData()) > 0 then
      'longstring print ConnData()
      if (linstr(ConnData(), "user=") > 0) and (linstr(ConnData(), "pwd=") > 0) then
        LoginMsg = "User name and/or password are not valid"
        UserNameOK = IsValidUser(ConnData())
        if UserNameOK then
          UserPwdOK = IsValidPwd(ConnData())
          if UserPwdOK then
            if PassKeyArr(curUser) = "" then
              LoginMsg = ""
              PassKeyArr(curUser) = Prefix + RandomStr(22)
              PassKey = PassKeyArr(curUser) + (right$("00" + str$(curUser), 2))
              UserTimeOutArr(curUser) = epoch(now) + TimeOutVal
              web transmit page ConnNum, "/index.html"
            else
              LoginMsg = "That user is already logged in"
              web transmit page ConnNum, "/password.html"
            endif
          else
            web transmit page ConnNum, "/password.html"
          endif
        else
          web transmit page ConnNum, "/password.html"
        endif
        exit sub
      endif
      curUser = GetCurUser(ConnData())
      if curUser > 0 then
        PassKey = PassKeyArr(curUser) + (right$("00" + str$(curUser), 2))
        UserTimeOutArr(curUser) = epoch(now) + TimeOutVal
        UserAccess = val(UserAccessArr(curUser))
        select case UserAccess
          case 1
            if (linstr(ConnData(), "GET / HTTP") > 0) or (linstr(ConnData(), "GET /index") > 0) then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /manual") > 0 then
              web transmit page ConnNum, "/manual.html"
            elseif linstr(ConnData(), "GET /channel") > 0 then
              web transmit page ConnNum, "/channel.html"
            elseif linstr(ConnData(), "GET /system") > 0 then
              web transmit page ConnNum, "/system.html"
            elseif linstr(ConnData(), "GET /debug") > 0 then
              web transmit page ConnNum, "/debug.html"
            elseif linstr(ConnData(), "Channel=") > 0 then
              web transmit page ConnNum, "/channel.html"
            else
              web transmit code ConnNum, 404
            endif
          case 2
            if (linstr(ConnData(), "GET / HTTP") > 0) or (linstr(ConnData(), "GET /index") > 0) then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /manual") > 0 then
              web transmit page ConnNum, "/manual.html"
            elseif linstr(ConnData(), "GET /channel") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /system") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /debug") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "Channel=") > 0 then
              web transmit page ConnNum, "/index.html"
            else
              web transmit code ConnNum, 404
            endif
          case 3
            if (linstr(ConnData(), "GET / HTTP") > 0) or (linstr(ConnData(), "GET /index") > 0) then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /manual") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /channel") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /system") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "GET /debug") > 0 then
              web transmit page ConnNum, "/index.html"
            elseif linstr(ConnData(), "Channel=") > 0 then
              web transmit page ConnNum, "/index.html"
            else
              web transmit code ConnNum, 404
            endif
        end select
      else
        web transmit page ConnNum, "/password.html"
      endif
    endif
  next ConnNum
end sub

sub GetUsers
  local integer i, j, CharPos
  local string TmpStr
  on error skip
  open UserList for input as #1
  select case mm.errno
    case 0
      j = 0
      do while not eof(#1)
        j = j + 1
        line input #1, TmpStr
      loop
      close #1
      Users = j
      dim string UserAccessArr(Users + 1) length 3
      dim string UserNameArr(Users + 1) length 20
      dim string UserPwdArr(Users + 1) length 20
      dim string PassKeyArr(Users + 1) length 30
      dim integer UserTimeOutArr(Users + 1)
      for i = 1 to Users
        UserTimeOutArr(i) = 0
      next i
      open UserList for input as #1
      for j = 1 to Users
        line input #1, TmpStr
        UserAccessArr(j) = left$(TmpStr, 1)
        TmpStr = mid$(TmpStr,3)
        CharPos = instr(TmpStr, ":")
        UserNameArr(j) = mid$(TmpStr, 1, CharPos - 1)
        UserPwdArr(j) = mid$(TmpStr, CharPos + 1)
      next j
      close #1
    case else
      ? "User list not found"
  end select
  on error skip
  close #1
end sub

function IsValidUser(ConnData() as integer) as integer
  local integer StartPos, EndPos, StrLen, tmpVal, i
  local string TmpStr
  IsValidUser = False
  curUser = 0
  StartPos = linstr(ConnData(), "user=", 1) + 5
  EndPos = linstr(ConnData(), "&pwd=", 1)
  if EndPos > StartPos then
    TmpStr = lgetstr$(ConnData(), StartPos, EndPos - StartPos)
    for i = 1 to Users
      if TmpStr = UserNameArr(i) then
        IsValidUser = True
        curUser = i
        exit function
      endif
    next i
  else
    IsValidUser = False
    curUser = 0
  endif
  IsValidUser = False
  curUser = 0
end function

function IsValidPwd(ConnData() as integer) as integer
  local integer StartPos, EndPos, StrLen, tmpVal, i
  local string TmpStr
  IsValidPwd = False
  if curUser > 0 then
    StartPos = (linstr(ConnData(), "pwd=", 1)) + 4
    StrLen = (llen(ConnData()) - StartPos) + 1
    if StrLen > 0 then
      pwd = lgetstr$(ConnData(), StartPos, StrLen)
      if pwd = UserPwdArr(curUser) then
        IsValidPwd = True
        exit function
      endif
    else
      IsValidPwd = False
      curUser = 0
    endif
  endif
  IsValidPwd = False
  curUser = 0
end function

function RandomStr (StrLen as integer) as string
  local integer tmpVal, i
  local string TmpStr
  for i = 1 to StrLen
    tmpVal = int((math(rand) * 97) + 48)
    select case tmpVal
      case 48 to 57
        TmpStr = TmpStr + chr$(tmpVal)
      case 65 to 90
        TmpStr = TmpStr + chr$(tmpVal)
      case 97 to 122
        TmpStr = TmpStr + chr$(tmpVal)
      case else
        i = i - 1
    end select
  next i
  RandomStr = TmpStr
end function

Function GetCurUser(ConnData() as integer) as integer
  local integer StartPos, EndPos, tmpVal
  local string TmpStr, tmpPassKey, tmpUser
  StartPos = linstr(ConnData(), Prefix, 1)
    if StartPos > 1 then
      TmpStr = lgetstr$(ConnData(), StartPos, 29)
        TmpStr = mid$(TmpStr, 1, 29)
        tmpUser = right$(TmpStr,2)
        tmpPassKey = left$(TmpStr, 27)
        tmpVal = val(tmpUser)
        select case tmpVal
          case 1 to Users
            if tmpPassKey <> PassKeyArr(tmpVal) then
              for i = 1 to Users
                if tmpPassKey = PassKeyArr(i) then
                  PassKeyArr(i) = ""
                  GetCurUser = 0
                  exit for
                endif
              next i
              elseif tmpPassKey = PassKeyArr(tmpVal) then
                GetCurUser = tmpVal
              else
                ? "Something else happened"
            endif
          case else
            GetCurUser = 0
        end select
      endif
    endif
  endif
  if GetCurUser = 0 then PassKey = ""
end function